/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.service;

import com.vendor.dto.ProductRequest;
import com.vendor.entity.Batches;
import com.vendor.entity.Certificate;
import com.vendor.repo.ProductRepository;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.Random;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class VendorService {
    @Autowired
    private ProductRepository productRepository;
    private static final String UPLOAD_DIR = "uploads/products/";

    public Certificate addProduct(ProductRequest request, MultipartFile file) throws IOException {
        Batches product = new Batches();
        product.setName(request.getProductName());
        product.setDescription(request.getDescription());
        product.setCertificatesCount(request.getCertificatesCount());
        product.setSalesLocation(request.getSalesLocation());
        product.setOwnerEmail(request.getOwnerEmail() != null ? request.getOwnerEmail() : "current-user@email.com");
        product.setOwnerName(request.getOwnerName() != null ? request.getOwnerName() : "Current Vendor");
        product.setBrandName(request.getBrandName() != null ? request.getBrandName() : "My Brand");
        product.setBatchId("BATCH-" + String.format("%04d", new Random().nextInt(10000)));
        if (file != null && !file.isEmpty()) {
            String fileName = String.valueOf(UUID.randomUUID()) + "_" + file.getOriginalFilename();
            Path path = Paths.get(UPLOAD_DIR + fileName, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, file.getBytes(), new OpenOption[0]);
            product.setImagePath(path.toString());
        }
        Certificate cert = Certificate.builder().certificateCode("CERT-" + UUID.randomUUID().toString().substring(0, 8).toUpperCase()).issueDate(LocalDate.now()).ownerName(product.getOwnerName()).brandName(product.getBrandName()).product(product).build();
        product.setCertificate(cert);
        this.productRepository.save((Object)product);
        return cert;
    }
}

