/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.service;

import com.vendor.entity.Product;
import com.vendor.repo.ProductRepo;
import com.vendor.security.UserContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProductsService {
    @Autowired
    private ProductRepo ProductRepository;
    @Value(value="${app.file.user-base-path}")
    private String uploadDir;

    public Product addProduct(String name, String description, String category, MultipartFile imageFile) throws IOException {
        Long vendorId = UserContext.getUserId();
        if (vendorId == null) {
            throw new RuntimeException("Vendor not authenticated");
        }
        Product product = new Product();
        product.setName(name);
        product.setDescription(description);
        product.setCategory(category);
        product.setVendorId(vendorId.longValue());
        String serialNumber = this.generateNextProductSerial(vendorId);
        product.setProductSerialNumber(serialNumber);
        if (imageFile != null && !imageFile.isEmpty()) {
            String fileName = this.saveFile(imageFile, category);
            product.setImageUrl(fileName);
        }
        return (Product)this.ProductRepository.save((Object)product);
    }

    public Product updateProduct(Long id, String name, String description, String category, MultipartFile imageFile) throws IOException {
        Product Product2 = (Product)this.ProductRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Product not found"));
        Product2.setName(name);
        Product2.setDescription(description);
        Product2.setCategory(category);
        if (imageFile != null && !imageFile.isEmpty()) {
            String fileName = this.saveFile(imageFile, category);
            Product2.setImageUrl(fileName);
        }
        return (Product)this.ProductRepository.save((Object)Product2);
    }

    public List<Product> getAllProducts() {
        return this.ProductRepository.findAll();
    }

    public Product getProductById(Long id) {
        return (Product)this.ProductRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Product not found"));
    }

    private String saveFile(MultipartFile file, String categoryName) throws IOException {
        String userFolder = UserContext.getEmail() + "_" + UserContext.getUserId();
        Path uploadPath = Paths.get(this.uploadDir, userFolder, categoryName).normalize();
        Files.createDirectories(uploadPath, new FileAttribute[0]);
        String originalFilename = file.getOriginalFilename();
        if (originalFilename == null || originalFilename.contains("..")) {
            throw new IOException("Invalid file name");
        }
        String extension = originalFilename.contains(".") ? originalFilename.substring(originalFilename.lastIndexOf(".")).toLowerCase() : "";
        List<String> allowedExt = List.of(".jpg", ".jpeg", ".png", ".webp");
        if (!allowedExt.contains(extension)) {
            throw new IOException("Only image files are allowed");
        }
        String uniqueFileName = String.valueOf(UUID.randomUUID()) + extension;
        Path filePath = uploadPath.resolve(uniqueFileName);
        Files.copy(file.getInputStream(), filePath, StandardCopyOption.REPLACE_EXISTING);
        return userFolder + "/" + categoryName + "/" + uniqueFileName;
    }

    public void deleteProduct(Long id) throws IOException {
        Product Product2 = (Product)this.ProductRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Product not found"));
        if (Product2.getImageUrl() != null) {
            Path filePath = Paths.get(this.uploadDir, Product2.getImageUrl());
            Files.deleteIfExists(filePath);
        }
        this.ProductRepository.delete((Object)Product2);
    }

    private String generateNextProductSerial(Long vendorId) {
        String lastSerial = this.ProductRepository.findTopSerialNumberByVendorId(vendorId);
        if (lastSerial == null || lastSerial.isEmpty()) {
            return "p0001";
        }
        int lastNumber = Integer.parseInt(lastSerial.substring(1));
        int nextNumber = lastNumber + 1;
        return String.format("p%04d", nextNumber);
    }
}

