/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.service;

import com.vendor.dto.VerificationResponse;
import com.vendor.entity.Batches;
import com.vendor.entity.Certificate;
import com.vendor.repo.CertificateRepo;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class CertificateService {
    private final CertificateRepo certificateRepo;

    public VerificationResponse verifyCertificate(String uniqueId) {
        Optional certOpt = this.certificateRepo.findByUniqueIdentifier(uniqueId);
        if (certOpt.isEmpty()) {
            return VerificationResponse.builder().isValid(false).message("This Certificate ID is invalid or does not exist.").build();
        }
        Certificate cert = (Certificate)certOpt.get();
        Batches batch = cert.getBatch();
        return VerificationResponse.builder().isValid(true).message("Verified Authentic").certificateId(cert.getCertificateSequence()).uniqueIdentifier(cert.getUniqueIdentifier()).productName(batch.getProductName()).batchCode(batch.getBatchCode()).issueDate(batch.getIssueDate()).brandName("Mekory Verified").productId(batch.getProductId()).QRCodeImagePath(batch.getImagePath()).build();
    }

    @Generated
    public CertificateService(CertificateRepo certificateRepo) {
        this.certificateRepo = certificateRepo;
    }
}

