/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.service;

import com.vendor.Exception.CategoryAlreadyExistsException;
import com.vendor.client.UserClient;
import com.vendor.entity.Category;
import com.vendor.repo.CategoryRepo;
import com.vendor.security.UserContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CategoryService {
    private final CategoryRepo categoryRepo;
    private final UserClient userClient;
    @Value(value="${app.file.user-base-path}")
    private String userBasePath;

    public Category addCategory(Category category) {
        try {
            Long currentUserId = UserContext.getUserId();
            if (currentUserId == null) {
                throw new RuntimeException("Security Error: User ID could not be retrieved from context. Check API Gateway headers.");
            }
            String currentUserEmail = UserContext.getEmail();
            if (this.categoryRepo.existsByCategoryNameIgnoreCase(category.getCategoryName())) {
                throw new CategoryAlreadyExistsException(category.getCategoryName() + " Category already exists");
            }
            category.setVendorId(currentUserId.longValue());
            this.createCategoryFolder(currentUserEmail, currentUserId, category.getCategoryName());
            return (Category)this.categoryRepo.save((Object)category);
        }
        catch (CategoryAlreadyExistsException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to add category", e);
        }
    }

    public List<Category> getAllCategories() {
        try {
            return this.categoryRepo.findAllByVendorId(UserContext.getUserId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return List.of();
        }
    }

    public boolean deleteCategory(int categoryId) {
        try {
            if (!this.categoryRepo.existsById((Object)categoryId)) {
                throw new CategoryAlreadyExistsException("Category does not exist");
            }
            this.categoryRepo.deleteById((Object)categoryId);
            return true;
        }
        catch (CategoryAlreadyExistsException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<String> getAllUserEmails() {
        try {
            return this.userClient.getUsers().stream().map(user -> user.getEmail()).toList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return List.of();
        }
    }

    private void createCategoryFolder(String userName, Long userId, String categoryName) {
        try {
            String userFolder = userName + "_" + userId;
            Path categoryPath = Paths.get(this.userBasePath, userFolder, categoryName);
            Files.createDirectories(categoryPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create category folder", e);
        }
    }

    @Generated
    public CategoryService(CategoryRepo categoryRepo, UserClient userClient) {
        this.categoryRepo = categoryRepo;
        this.userClient = userClient;
    }
}

