/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.service;

import com.vendor.Exception.BatchNotFoundException;
import com.vendor.dto.BatchesDto;
import com.vendor.entity.Batches;
import com.vendor.entity.Certificate;
import com.vendor.entity.Items;
import com.vendor.repo.BatchesRepo;
import com.vendor.repo.CertificateRepo;
import com.vendor.repo.ItemRepo;
import com.vendor.security.UserContext;
import com.vendor.utils.QrZipUtils;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import jakarta.transaction.Transactional;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BatchService {
    private final BatchesRepo batchesRepo;
    private final QrZipUtils qrZipUtils;
    private final ItemRepo itemRepo;
    private final JavaMailSender mailSender;
    private final CertificateRepo certificateRepo;
    @Value(value="${spring.mail.username}")
    private String senderEmail;
    @Value(value="${app.file.user-base-path}")
    private String UPLOAD_DIR;
    private static final String BASE_QR_PATH = "C:/dev/QRCodes/";
    private static final String VERIFICATION_URL = "http://localhost:8086/api/public/verification?id=";

    @Transactional
    public Batches createBatch(BatchesDto batchDto) {
        File zipFile = null;
        try {
            Long userId = UserContext.getUserId();
            String userEmail = UserContext.getEmail();
            userEmail = "kc244493@gmail.com";
            Batches batchRequest = new Batches();
            batchRequest.setProductId(batchDto.getProductId());
            batchRequest.setProductName(batchDto.getProductName());
            batchRequest.setCategoryId(batchDto.getCategoryId());
            batchRequest.setQuantity(batchDto.getQuantity());
            batchRequest.setDescription(batchDto.getDescription());
            batchRequest.setSalesLocation(batchDto.getLocation());
            batchRequest.setIssueDate(batchDto.getIssueDate());
            batchRequest.setVendorId(userId);
            batchRequest.setSerialNumber(batchDto.getSerialNumber());
            long existingBatches = this.batchesRepo.countByProductId(batchDto.getProductId());
            String batchCode = String.format("b%03d", existingBatches + 1L);
            batchRequest.setBatchCode(batchCode);
            MultipartFile imageFile = batchDto.getImage();
            if (imageFile != null && !imageFile.isEmpty()) {
                String fileName = this.saveFile(imageFile, batchDto.getProductName());
                batchRequest.setImagePath(fileName);
            }
            ArrayList<Certificate> certificates = new ArrayList<Certificate>();
            ArrayList<Items> itemsList = new ArrayList<Items>();
            HashMap<CallSite, byte[]> qrImages = new HashMap<CallSite, byte[]>();
            String sanitizedProductName = batchDto.getProductName().replaceAll("\\s+", "_");
            String qrRelativeFolder = sanitizedProductName + "/Batch_" + batchCode + "/";
            Path physicalPath = Paths.get(BASE_QR_PATH, qrRelativeFolder);
            Files.createDirectories(physicalPath, new FileAttribute[0]);
            for (int i = 1; i <= batchDto.getQuantity(); ++i) {
                String certSequence = String.format("c%04d", i);
                String uniqueIdentifier = batchDto.getProductId() + "-" + batchCode + "-" + certSequence;
                String qrFileName = certSequence + ".png";
                byte[] qrImage = this.qrZipUtils.generateQRCodeImage(VERIFICATION_URL + uniqueIdentifier, 300, 300);
                Files.write(physicalPath.resolve(qrFileName), qrImage, new OpenOption[0]);
                Certificate cert = Certificate.builder().certificateSequence(certSequence).uniqueIdentifier(uniqueIdentifier).batch(batchRequest).issueDate(batchDto.getIssueDate()).brandName(batchRequest.getBrandName()).ownerName(batchRequest.getOwnerName()).QrQodePath(qrRelativeFolder + qrFileName).vendorId(userId.longValue()).build();
                Items item = new Items();
                item.setBatch(batchRequest);
                item.setCertificate(cert);
                item.setActive(true);
                item.setIssueDate(batchDto.getIssueDate());
                item.setImagePath(batchRequest.getImagePath());
                item.setBatchCode(batchCode);
                item.setVendorId(userId.longValue());
                certificates.add(cert);
                itemsList.add(item);
                item.setQrQodePath(qrRelativeFolder + qrFileName);
                certificates.add(cert);
                itemsList.add(item);
                qrImages.put((CallSite)((Object)qrFileName), qrImage);
            }
            batchRequest.setCertificates(certificates);
            batchRequest.setItems(itemsList);
            Batches savedBatch = (Batches)this.batchesRepo.save((Object)batchRequest);
            String zipFileName = "Batch_" + batchCode + "_QRs.zip";
            String zipFilePath = this.qrZipUtils.createZipFile("C:/dev/QRCodes/temp_zips", zipFileName, qrImages);
            zipFile = new File(zipFilePath);
            this.sendEmailWithAttachment(userEmail, zipFilePath, batchDto.getProductName(), batchCode);
            Batches batches = savedBatch;
            return batches;
        }
        catch (Exception e) {
            throw new RuntimeException("Error processing batch: " + e.getMessage(), e);
        }
        finally {
            boolean deleted;
            if (zipFile != null && zipFile.exists() && !(deleted = zipFile.delete())) {
                System.err.println("Failed to delete temporary zip file: " + zipFile.getAbsolutePath());
            }
        }
    }

    private void sendEmailWithAttachment(String to, String filePath, String productName, String batchCode) throws MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setFrom(this.senderEmail);
        helper.setTo(to);
        helper.setSubject("QR Codes for Batch: " + batchCode + " - " + productName);
        helper.setText("Hello,\n\nHere are the QR codes for your newly created product batch.\n\nRegards,\nMekory Team");
        FileSystemResource file = new FileSystemResource(new File(filePath));
        helper.addAttachment(file.getFilename(), (InputStreamSource)file);
        this.mailSender.send(message);
    }

    public List<Batches> getAllBatches() {
        Long vendorId = UserContext.getUserId();
        return this.batchesRepo.findByVendorId(vendorId);
    }

    public Batches getBatchById(Long id) {
        Long vendorId = UserContext.getUserId();
        return (Batches)this.batchesRepo.findByIdAndVendorId(id, vendorId).orElseThrow(() -> new BatchNotFoundException("Batch not found"));
    }

    public List<Batches> getBatchesByProductId(Long productId) {
        Long vendorId = UserContext.getUserId();
        return this.batchesRepo.findByProductIdAndVendorId(productId, vendorId);
    }

    @Transactional
    public void deleteBatch(Long id) {
        Long vendorId = UserContext.getUserId();
        Batches batch = (Batches)this.batchesRepo.findByIdAndVendorId(id, vendorId).orElseThrow(() -> new RuntimeException("Batch not found or access denied"));
        this.batchesRepo.delete((Object)batch);
    }

    public Batches toggleBatchStatus(Long batchId) {
        Batches batch;
        Long vendorId = UserContext.getUserId();
        batch.setActive(!(batch = (Batches)this.batchesRepo.findByIdAndVendorId(batchId, vendorId).orElseThrow(() -> new RuntimeException("Batch not found or access denied"))).isActive());
        return (Batches)this.batchesRepo.save((Object)batch);
    }

    private String saveFile(MultipartFile file, String categoryName) throws IOException {
        String userFolder = UserContext.getEmail() + "_" + UserContext.getUserId();
        Path uploadPath = Paths.get(this.UPLOAD_DIR, userFolder, categoryName).normalize();
        uploadPath = Path.of(String.valueOf(uploadPath) + "/Batches", new String[0]);
        Files.createDirectories(uploadPath, new FileAttribute[0]);
        String originalFilename = file.getOriginalFilename();
        if (originalFilename == null || originalFilename.contains("..")) {
            throw new IOException("Invalid file name");
        }
        String extension = originalFilename.contains(".") ? originalFilename.substring(originalFilename.lastIndexOf(".")).toLowerCase() : "";
        List<String> allowedExt = List.of(".jpg", ".jpeg", ".png", ".webp");
        if (!allowedExt.contains(extension)) {
            throw new IOException("Only image files are allowed");
        }
        String uniqueFileName = String.valueOf(UUID.randomUUID()) + extension;
        Path filePath = uploadPath.resolve(uniqueFileName);
        Files.copy(file.getInputStream(), filePath, StandardCopyOption.REPLACE_EXISTING);
        return userFolder + "/" + categoryName + "//Batches/" + uniqueFileName;
    }

    public List<Items> getItemsByBatch(Long batchId) {
        Long vendorId = UserContext.getUserId();
        return this.itemRepo.findByBatchIdAndVendorId(batchId, vendorId);
    }

    public Certificate getCertificateById(Long certificateId) {
        Long vendorId = UserContext.getUserId();
        return this.certificateRepo.findByVendorIdAndId(vendorId, certificateId);
    }

    public Certificate findByVendorIdAndUniqueIdentifier(String certificateId) {
        Long vendorId = UserContext.getUserId();
        return this.certificateRepo.findByVendorIdAndCertificateSequence(vendorId, certificateId);
    }

    @Generated
    public BatchService(BatchesRepo batchesRepo, QrZipUtils qrZipUtils, ItemRepo itemRepo, JavaMailSender mailSender, CertificateRepo certificateRepo) {
        this.batchesRepo = batchesRepo;
        this.qrZipUtils = qrZipUtils;
        this.itemRepo = itemRepo;
        this.mailSender = mailSender;
        this.certificateRepo = certificateRepo;
    }
}

