/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.security;

import com.vendor.security.UserContext;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class UserContextFilter
implements Filter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String userIdHeader = httpServletRequest.getHeader("X-User-Id");
        String email = httpServletRequest.getHeader("X-User-Email");
        String role = httpServletRequest.getHeader("X-User-Role");
        if (userIdHeader != null && !userIdHeader.isBlank()) {
            try {
                Long userId = Long.parseLong(userIdHeader);
                UserContext.setUserId((Long)userId);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid X-User-Id header: " + userIdHeader);
            }
        }
        if (email != null) {
            UserContext.setEmail((String)email);
        }
        if (role != null) {
            UserContext.setRole((String)role);
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            UserContext.clear();
        }
    }
}

