/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.vendor.entity.Batches;
import com.vendor.entity.Certificate;
import com.vendor.entity.Items;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.time.LocalDate;
import lombok.Generated;

@Entity
@Table(name="certificates")
public class Certificate {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(unique=true)
    private String certificateCode;
    private String certificateSequence;
    @Column(unique=true)
    private String uniqueIdentifier;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="batch_id")
    @JsonIgnoreProperties(value={"certificates", "items"})
    private Batches batch;
    private LocalDate issueDate;
    private String ownerName;
    private String brandName;
    private String QrQodePath;
    private long itemId;
    @OneToOne(mappedBy="certificate")
    @JsonIgnore
    private Items item;
    private long vendorId;
    @OneToOne
    @JoinColumn(name="product_id")
    private Batches product;

    @Generated
    public static CertificateBuilder builder() {
        return new CertificateBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getCertificateCode() {
        return this.certificateCode;
    }

    @Generated
    public String getCertificateSequence() {
        return this.certificateSequence;
    }

    @Generated
    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    @Generated
    public Batches getBatch() {
        return this.batch;
    }

    @Generated
    public LocalDate getIssueDate() {
        return this.issueDate;
    }

    @Generated
    public String getOwnerName() {
        return this.ownerName;
    }

    @Generated
    public String getBrandName() {
        return this.brandName;
    }

    @Generated
    public String getQrQodePath() {
        return this.QrQodePath;
    }

    @Generated
    public long getItemId() {
        return this.itemId;
    }

    @Generated
    public Items getItem() {
        return this.item;
    }

    @Generated
    public long getVendorId() {
        return this.vendorId;
    }

    @Generated
    public Batches getProduct() {
        return this.product;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCertificateCode(String certificateCode) {
        this.certificateCode = certificateCode;
    }

    @Generated
    public void setCertificateSequence(String certificateSequence) {
        this.certificateSequence = certificateSequence;
    }

    @Generated
    public void setUniqueIdentifier(String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
    }

    @Generated
    public void setBatch(Batches batch) {
        this.batch = batch;
    }

    @Generated
    public void setIssueDate(LocalDate issueDate) {
        this.issueDate = issueDate;
    }

    @Generated
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Generated
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    @Generated
    public void setQrQodePath(String QrQodePath) {
        this.QrQodePath = QrQodePath;
    }

    @Generated
    public void setItemId(long itemId) {
        this.itemId = itemId;
    }

    @Generated
    public void setItem(Items item) {
        this.item = item;
    }

    @Generated
    public void setVendorId(long vendorId) {
        this.vendorId = vendorId;
    }

    @Generated
    public void setProduct(Batches product) {
        this.product = product;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getItemId() != other.getItemId()) {
            return false;
        }
        if (this.getVendorId() != other.getVendorId()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$certificateCode = this.getCertificateCode();
        String other$certificateCode = other.getCertificateCode();
        if (this$certificateCode == null ? other$certificateCode != null : !this$certificateCode.equals(other$certificateCode)) {
            return false;
        }
        String this$certificateSequence = this.getCertificateSequence();
        String other$certificateSequence = other.getCertificateSequence();
        if (this$certificateSequence == null ? other$certificateSequence != null : !this$certificateSequence.equals(other$certificateSequence)) {
            return false;
        }
        String this$uniqueIdentifier = this.getUniqueIdentifier();
        String other$uniqueIdentifier = other.getUniqueIdentifier();
        if (this$uniqueIdentifier == null ? other$uniqueIdentifier != null : !this$uniqueIdentifier.equals(other$uniqueIdentifier)) {
            return false;
        }
        Batches this$batch = this.getBatch();
        Batches other$batch = other.getBatch();
        if (this$batch == null ? other$batch != null : !this$batch.equals(other$batch)) {
            return false;
        }
        LocalDate this$issueDate = this.getIssueDate();
        LocalDate other$issueDate = other.getIssueDate();
        if (this$issueDate == null ? other$issueDate != null : !((Object)this$issueDate).equals(other$issueDate)) {
            return false;
        }
        String this$ownerName = this.getOwnerName();
        String other$ownerName = other.getOwnerName();
        if (this$ownerName == null ? other$ownerName != null : !this$ownerName.equals(other$ownerName)) {
            return false;
        }
        String this$brandName = this.getBrandName();
        String other$brandName = other.getBrandName();
        if (this$brandName == null ? other$brandName != null : !this$brandName.equals(other$brandName)) {
            return false;
        }
        String this$QrQodePath = this.getQrQodePath();
        String other$QrQodePath = other.getQrQodePath();
        if (this$QrQodePath == null ? other$QrQodePath != null : !this$QrQodePath.equals(other$QrQodePath)) {
            return false;
        }
        Items this$item = this.getItem();
        Items other$item = other.getItem();
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        Batches this$product = this.getProduct();
        Batches other$product = other.getProduct();
        return !(this$product == null ? other$product != null : !this$product.equals(other$product));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Certificate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $itemId = this.getItemId();
        result = result * 59 + (int)($itemId >>> 32 ^ $itemId);
        long $vendorId = this.getVendorId();
        result = result * 59 + (int)($vendorId >>> 32 ^ $vendorId);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $certificateCode = this.getCertificateCode();
        result = result * 59 + ($certificateCode == null ? 43 : $certificateCode.hashCode());
        String $certificateSequence = this.getCertificateSequence();
        result = result * 59 + ($certificateSequence == null ? 43 : $certificateSequence.hashCode());
        String $uniqueIdentifier = this.getUniqueIdentifier();
        result = result * 59 + ($uniqueIdentifier == null ? 43 : $uniqueIdentifier.hashCode());
        Batches $batch = this.getBatch();
        result = result * 59 + ($batch == null ? 43 : $batch.hashCode());
        LocalDate $issueDate = this.getIssueDate();
        result = result * 59 + ($issueDate == null ? 43 : ((Object)$issueDate).hashCode());
        String $ownerName = this.getOwnerName();
        result = result * 59 + ($ownerName == null ? 43 : $ownerName.hashCode());
        String $brandName = this.getBrandName();
        result = result * 59 + ($brandName == null ? 43 : $brandName.hashCode());
        String $QrQodePath = this.getQrQodePath();
        result = result * 59 + ($QrQodePath == null ? 43 : $QrQodePath.hashCode());
        Items $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        Batches $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Certificate(id=" + this.getId() + ", certificateCode=" + this.getCertificateCode() + ", certificateSequence=" + this.getCertificateSequence() + ", uniqueIdentifier=" + this.getUniqueIdentifier() + ", issueDate=" + String.valueOf(this.getIssueDate()) + ", ownerName=" + this.getOwnerName() + ", brandName=" + this.getBrandName() + ", QrQodePath=" + this.getQrQodePath() + ", itemId=" + this.getItemId() + ", item=" + String.valueOf(this.getItem()) + ", vendorId=" + this.getVendorId() + ", product=" + String.valueOf(this.getProduct()) + ")";
    }

    @Generated
    public Certificate(Long id, String certificateCode, String certificateSequence, String uniqueIdentifier, Batches batch, LocalDate issueDate, String ownerName, String brandName, String QrQodePath, long itemId, Items item, long vendorId, Batches product) {
        this.id = id;
        this.certificateCode = certificateCode;
        this.certificateSequence = certificateSequence;
        this.uniqueIdentifier = uniqueIdentifier;
        this.batch = batch;
        this.issueDate = issueDate;
        this.ownerName = ownerName;
        this.brandName = brandName;
        this.QrQodePath = QrQodePath;
        this.itemId = itemId;
        this.item = item;
        this.vendorId = vendorId;
        this.product = product;
    }

    @Generated
    public Certificate() {
    }
}

