/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.controller;

import com.vendor.dto.VerificationResponse;
import com.vendor.service.CertificateService;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.view.RedirectView;

@RestController
@RequestMapping(value={"/api/public"})
public class PublicController {
    private final CertificateService certificateService;

    @GetMapping(value={"/verify"})
    public ResponseEntity<VerificationResponse> verifyItem(@RequestParam(value="id") String uniqueId) {
        VerificationResponse response = this.certificateService.verifyCertificate(uniqueId);
        if (response.isValid()) {
            return ResponseEntity.ok((Object)response);
        }
        return ResponseEntity.status((int)404).body((Object)response);
    }

    @GetMapping(value={"/verification"})
    public RedirectView verifyCertificate(@RequestParam(value="id") String uniqueId) {
        VerificationResponse response = this.certificateService.verifyCertificate(uniqueId);
        String redirectUrl = "http://localhost:5173/varify?certificateId=" + response.getCertificateId();
        return new RedirectView(redirectUrl);
    }

    @Generated
    public PublicController(CertificateService certificateService) {
        this.certificateService = certificateService;
    }
}

