/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.controller;

import com.vendor.entity.Product;
import com.vendor.service.ProductsService;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/product"})
public class ProductsController {
    @Autowired
    private ProductsService productService;

    @PostMapping(value={"/add"})
    public ResponseEntity<?> addproduct(@RequestParam(value="name") String name, @RequestParam(value="description") String description, @RequestParam(value="category") String category, @RequestParam(value="image", required=false) MultipartFile image) {
        try {
            Product newproduct = this.productService.addProduct(name, description, category, image);
            return ResponseEntity.ok((Object)newproduct);
        }
        catch (IOException e) {
            return ResponseEntity.internalServerError().body((Object)("Error saving file: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/edit/{id}"})
    public ResponseEntity<?> updateproduct(@PathVariable Long id, @RequestParam(value="name") String name, @RequestParam(value="description") String description, @RequestParam(value="category") String category, @RequestParam(value="image", required=false) MultipartFile image) {
        try {
            Product updatedproduct = this.productService.updateProduct(id, name, description, category, image);
            return ResponseEntity.ok((Object)updatedproduct);
        }
        catch (RuntimeException e) {
            return ResponseEntity.badRequest().body((Object)e.getMessage());
        }
        catch (IOException e) {
            return ResponseEntity.internalServerError().body((Object)("Error saving image: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/getAll"})
    public ResponseEntity<List<Product>> getAllproducts() {
        return ResponseEntity.ok((Object)this.productService.getAllProducts());
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<?> getproduct(@PathVariable Long id) {
        try {
            return ResponseEntity.ok((Object)this.productService.getProductById(id));
        }
        catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<?> deleteproduct(@PathVariable Long id) {
        try {
            this.productService.deleteProduct(id);
            return ResponseEntity.ok((Object)"product deleted successfully");
        }
        catch (Exception e) {
            return ResponseEntity.internalServerError().body((Object)("Error deleting product: " + e.getMessage()));
        }
    }
}

