/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.controller;

import com.vendor.entity.Category;
import com.vendor.service.CategoryService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/category"})
public class CategoryController {
    private final CategoryService categoryService;

    @PostMapping(value={"/addCategory"})
    public ResponseEntity<Category> addCategory(@RequestBody Category category) {
        return ResponseEntity.ok((Object)this.categoryService.addCategory(category));
    }

    @GetMapping(value={"/getAll"})
    public ResponseEntity<List<Category>> getAllCategories() {
        return ResponseEntity.ok((Object)this.categoryService.getAllCategories());
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Boolean> deleteCatogery(@RequestHeader(value="Authorization") String tokenHeader, @PathVariable int id) {
        boolean isDeleted = this.categoryService.deleteCategory(id);
        return new ResponseEntity((Object)isDeleted, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/emails"})
    public ResponseEntity<List<String>> getAllUsers(@RequestHeader(value="Authorization") String tokenHeader) {
        List users = this.categoryService.getAllUserEmails();
        return new ResponseEntity((Object)users, (HttpStatusCode)HttpStatus.OK);
    }

    @Generated
    public CategoryController(CategoryService categoryService) {
        this.categoryService = categoryService;
    }
}

