/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vendor.dto.BatchesDto;
import com.vendor.entity.Batches;
import com.vendor.entity.Certificate;
import com.vendor.entity.Items;
import com.vendor.service.BatchService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vendor/batches"})
public class BatchesController {
    private final BatchService batchService;
    private final ObjectMapper objectMapper;

    @PostMapping(value={"/create"}, consumes={"multipart/form-data"})
    public ResponseEntity<Batches> createBatch(@ModelAttribute BatchesDto batchDto) {
        try {
            Batches createdBatch = this.batchService.createBatch(batchDto);
            return ResponseEntity.ok((Object)createdBatch);
        }
        catch (Exception e) {
            throw new RuntimeException("Batch creation failed: " + e.getMessage());
        }
    }

    @GetMapping
    public ResponseEntity<List<Batches>> getAllBatches() {
        return ResponseEntity.ok((Object)this.batchService.getAllBatches());
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Batches> getBatchById(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.batchService.getBatchById(id));
    }

    @GetMapping(value={"/product/{productId}"})
    public ResponseEntity<List<Batches>> getBatchesByProduct(@PathVariable Long productId) {
        return ResponseEntity.ok((Object)this.batchService.getBatchesByProductId(productId));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<String> deleteBatch(@PathVariable Long id) {
        this.batchService.deleteBatch(id);
        return ResponseEntity.ok((Object)"Batch deleted successfully");
    }

    @PatchMapping(value={"/{id}/toggle-status"})
    public ResponseEntity<Batches> toggleBatchStatus(@PathVariable Long id) {
        Batches updatedBatch = this.batchService.toggleBatchStatus(id);
        return ResponseEntity.ok((Object)updatedBatch);
    }

    @GetMapping(value={"/batch/{batchId}"})
    public ResponseEntity<List<Items>> getItemsByBatch(@PathVariable Long batchId) {
        List ItemList = this.batchService.getItemsByBatch(batchId);
        return ResponseEntity.ok((Object)ItemList);
    }

    @GetMapping(value={"/certificate/{certificateId}"})
    public ResponseEntity<Certificate> getCertificateById(@PathVariable Long certificateId) {
        Certificate certificate = this.batchService.getCertificateById(certificateId);
        return ResponseEntity.ok((Object)certificate);
    }

    @GetMapping(value={"/public/certificate/{certificateId}"})
    public ResponseEntity<Certificate> findByVendorIdAndUniqueIdentifier(@PathVariable String certificateId) {
        Certificate certificate = this.batchService.findByVendorIdAndUniqueIdentifier(certificateId);
        return ResponseEntity.ok((Object)certificate);
    }

    @Generated
    public BatchesController(BatchService batchService, ObjectMapper objectMapper) {
        this.batchService = batchService;
        this.objectMapper = objectMapper;
    }
}

