/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.config;

import java.nio.file.Paths;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebConfig
implements WebMvcConfigurer {
    @Value(value="${app.file.user-base-path}")
    private String uploadDir;
    @Value(value="${app.file.qr-base-path}")
    private String qrUploadDir;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        Object productPath = Paths.get(this.uploadDir, new String[0]).toUri().toString();
        Object qrPath = Paths.get(this.qrUploadDir, new String[0]).toUri().toString();
        if (!((String)productPath).endsWith("/")) {
            productPath = (String)productPath + "/";
        }
        if (!((String)qrPath).endsWith("/")) {
            qrPath = (String)qrPath + "/";
        }
        System.out.println("Serving Product Images from: " + (String)productPath);
        System.out.println("Serving QR Images from: " + (String)qrPath);
        registry.addResourceHandler(new String[]{"/images/**"}).addResourceLocations(new String[]{productPath});
        registry.addResourceHandler(new String[]{"/images/qr/**"}).addResourceLocations(new String[]{qrPath});
    }
}

