/*
 * Decompiled with CFR 0.152.
 */
package com.auth.service;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class EmailService {
    private final JavaMailSender javaMailSender;
    @Value(value="${spring.mail.username}")
    private String fromEmail;

    public void sendEmail(String to, String otp) {
        try {
            MimeMessage message = this.javaMailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
            helper.setFrom(this.fromEmail);
            helper.setTo(to);
            helper.setSubject("Account Verification OTP");
            String htmlBody = "<html>\n    <body>\n        <h2>Your Verification Code</h2>\n        <p>Your OTP is:</p>\n        <h3 style=\"color:blue;\">%s</h3>\n        <p>This OTP is valid for 5 minutes.</p>\n    </body>\n</html>\n".formatted(otp);
            helper.setText(htmlBody, true);
            this.javaMailSender.send(message);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Failed to send OTP email", e);
        }
    }

    @Generated
    public EmailService(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }
}

