/*
 * Decompiled with CFR 0.152.
 */
package com.auth.service;

import com.auth.dto.RegisterRequest;
import com.auth.entity.User;
import com.auth.repo.UserRepository;
import com.auth.service.EmailService;
import com.auth.service.JwtService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AuthService {
    @Autowired
    private UserRepository repository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private JwtService jwtService;
    @Autowired
    private EmailService emailService;
    private static final String UPLOAD_DIR = "uploads/logos/";

    public String registerUser(RegisterRequest request, MultipartFile file) {
        try {
            User user = new User();
            user.setBrandName(request.getBrandName());
            user.setBrandDescription(request.getBrandDescription());
            user.setPrimaryContactName(request.getPrimaryContactName());
            user.setEmail(request.getEmail());
            user.setPhone(request.getPhone());
            user.setCountry(request.getCountry());
            user.setWebsiteUrl(request.getWebsiteUrl());
            user.setSocialMediaFacebook(request.getSocialMediaFacebook());
            user.setSocialMediaTwitter(request.getSocialMediaTwitter());
            user.setSocialMediaInstagram(request.getSocialMediaInstagram());
            user.setOtherLink1(request.getOtherLink1());
            user.setOtherLink2(request.getOtherLink2());
            if (file != null && !file.isEmpty()) {
                String fileName = String.valueOf(UUID.randomUUID()) + "_" + file.getOriginalFilename();
                Path uploadDirPath = Paths.get(UPLOAD_DIR, new String[0]);
                if (!Files.exists(uploadDirPath, new LinkOption[0])) {
                    Files.createDirectories(uploadDirPath, new FileAttribute[0]);
                }
                Path filePath = uploadDirPath.resolve(fileName);
                Files.write(filePath, file.getBytes(), new OpenOption[0]);
                System.out.println("Upload dir: " + String.valueOf(uploadDirPath.toAbsolutePath()));
                System.out.println("File path: " + String.valueOf(filePath.toAbsolutePath()));
                user.setBrandLogoPath(filePath.toString());
            }
            user.setPassword(this.passwordEncoder.encode((CharSequence)request.getPassword()));
            user.setRole(User.Role.VENDOR);
            String otp = String.format("%04d", new Random().nextInt(10000));
            user.setOtp(otp);
            user.setVerified(false);
            this.repository.save((Object)user);
            this.emailService.sendEmail(user.getEmail(), otp);
            return "User registered successfully.";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "File upload failed. Please try again.";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "User registration failed. Please contact support.";
        }
    }

    public boolean verifyOtp(String email, String otp) {
        User user = (User)this.repository.findByEmail(email).orElseThrow(() -> new RuntimeException("User not found"));
        if (user.getOtp().equals(otp)) {
            user.setVerified(true);
            user.setOtp(null);
            this.repository.save((Object)user);
            return true;
        }
        return false;
    }

    public boolean verifyOtp2(String email, String otp) {
        User user = (User)this.repository.findByEmail(email).orElseThrow(() -> new RuntimeException("User not found"));
        if (user.getOtp() != null && user.getOtp().equals(otp)) {
            user.setVerified(true);
            user.setOtp(null);
            this.repository.save((Object)user);
            return true;
        }
        return false;
    }

    public String generateToken(String role, long id, String email) {
        return this.jwtService.generateToken(email, role, id);
    }

    public void validateToken(String token) {
        this.jwtService.validateToken(token);
    }

    public User.Role getUserRole(String email) {
        return this.repository.findByEmail(email).map(User::getRole).orElse(User.Role.CLIENT);
    }

    public User getUserByUsername(String email) {
        return (User)this.repository.findByEmail(email).orElseThrow(() -> new RuntimeException("User not found: " + email));
    }
}

