/*
 * Decompiled with CFR 0.152.
 */
package com.auth.controller;

import com.auth.dto.AuthRequest;
import com.auth.dto.LoginResponse;
import com.auth.dto.RegisterRequest;
import com.auth.entity.User;
import com.auth.service.AuthService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/auth"})
public class AuthController {
    @Autowired
    private AuthService service;
    @Autowired
    private AuthenticationManager authenticationManager;

    @PostMapping(value={"/register"}, consumes={"multipart/form-data"})
    public ResponseEntity<String> registerUser(@RequestPart(value="data") String dataJson, @RequestPart(value="file", required=false) MultipartFile file) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            RegisterRequest request = (RegisterRequest)objectMapper.readValue(dataJson, RegisterRequest.class);
            String response = this.service.registerUser(request, file);
            return ResponseEntity.ok((Object)response);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return ResponseEntity.badRequest().body((Object)"Invalid request data format.");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Registration failed. Please try again later.");
        }
    }

    @PostMapping(value={"/login"})
    public ResponseEntity<LoginResponse> getToken(@RequestBody AuthRequest authRequest) {
        Authentication authenticate = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)authRequest.getUsername(), (Object)authRequest.getPassword()));
        if (!authenticate.isAuthenticated()) {
            throw new RuntimeException("Invalid access");
        }
        User user = this.service.getUserByUsername(authRequest.getUsername());
        String token = this.service.generateToken(user.getRole().name(), user.getId().longValue(), user.getEmail());
        LoginResponse response = new LoginResponse(token, user.getRole().name(), user.getId(), user.getEmail());
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/validate"})
    public String validateToken(@RequestParam(value="token") String token) {
        this.service.validateToken(token);
        return "Token is valid";
    }

    @PostMapping(value={"/verify"})
    public String verifyOtp(@RequestParam String email, @RequestParam String otp) {
        boolean isVerified = this.service.verifyOtp2(email, otp);
        if (isVerified) {
            return "Account verified successfully.";
        }
        throw new RuntimeException("Invalid OTP.");
    }
}

