/*
 * Decompiled with CFR 0.152.
 */
package com.gateway.fiter;

import com.gateway.fiter.AuthFilter;
import com.gateway.fiter.JwtUtil;
import com.gateway.fiter.Validator;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class AuthFilter
extends AbstractGatewayFilterFactory<Config> {
    @Autowired
    private Validator validator;
    @Autowired
    private JwtUtil jwtUtil;

    public AuthFilter() {
        super(Config.class);
    }

    public GatewayFilter apply(Config config) {
        return (exchange, chain) -> {
            if (this.validator.predicate.test(exchange.getRequest())) {
                String authHeader = exchange.getRequest().getHeaders().getFirst("Authorization");
                if (authHeader == null || !authHeader.startsWith("Bearer ")) {
                    return this.onError(exchange, "Missing or Invalid Authorization Header", HttpStatus.UNAUTHORIZED);
                }
                String jwtToken = authHeader.substring(7);
                try {
                    this.jwtUtil.validateToken(jwtToken);
                    Number userIdNumber = (Number)this.extractClaim(jwtToken, claims -> (Number)claims.get("userId", Number.class));
                    String userId = String.valueOf(userIdNumber.longValue());
                    String email = (String)this.extractClaim(jwtToken, claims -> (String)claims.get("email", String.class));
                    String role = (String)this.extractClaim(jwtToken, claims -> (String)claims.get("role", String.class));
                    ServerWebExchange mutatedExchange = exchange.mutate().request(builder -> builder.header("X-User-Id", new String[]{userId}).header("X-User-Email", new String[]{email}).header("X-User-Role", new String[]{role})).build();
                    return chain.filter(mutatedExchange);
                }
                catch (Exception e) {
                    return this.onError(exchange, "Invalid Access Token", HttpStatus.UNAUTHORIZED);
                }
            }
            return chain.filter(exchange);
        };
    }

    public <T> T extractClaim(String token, Function<Claims, T> claimsResolver) {
        Claims claims = (Claims)Jwts.parserBuilder().setSigningKey(this.getSignKey()).build().parseClaimsJws(token).getBody();
        return claimsResolver.apply(claims);
    }

    private Key getSignKey() {
        byte[] keyBytes = (byte[])Decoders.BASE64.decode((Object)"5367566B59703373367639792F423F4528482B4D6251655468576D5A71347437");
        return Keys.hmacShaKeyFor((byte[])keyBytes);
    }

    private Mono<Void> onError(ServerWebExchange exchange, String err, HttpStatus status) {
        exchange.getResponse().setStatusCode((HttpStatusCode)status);
        return exchange.getResponse().setComplete();
    }
}

